/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding.pathjobs;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.pathfinding.PathingOptions;
import com.minecolonies.api.entity.pathfinding.PathingStuckHandler;
import com.minecolonies.coremod.colony.managers.RaidManager;
import com.minecolonies.coremod.entity.pathfinding.Node;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.AbstractPathJob;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LadderBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class PathJobRaiderPathing
extends AbstractPathJob {
    private final double THROUGH_BLOCK_COST = 30.0;
    private final List<IBuilding> buildings;
    private final BlockPos direction;
    private double addCost = 1.0;

    public PathJobRaiderPathing(List<IBuilding> buildings, World world, @NotNull BlockPos start, BlockPos targetSpawnPoint, int range) {
        super(world, start, targetSpawnPoint, range, null);
        this.buildings = buildings;
        this.direction = targetSpawnPoint;
        this.setPathingOptions(new PathingOptions().withJumpCost(1.0).withStartSwimCost(1.0).withSwimCost(1.0).withCanSwim(true).withCanEnterDoors(true));
    }

    @Override
    protected double computeHeuristic(BlockPos pos) {
        return Math.sqrt(this.direction.func_177951_i((Vector3i)pos));
    }

    @Override
    protected boolean isAtDestination(Node n) {
        if (this.start.func_177951_i((Vector3i)n.pos) < 2500.0) {
            return false;
        }
        return this.direction.func_177951_i((Vector3i)n.pos) < 2500.0 && RaidManager.isValidSpawnPoint(this.buildings, n.pos);
    }

    @Override
    protected double getNodeResultScore(Node n) {
        return Math.sqrt(this.direction.func_177951_i((Vector3i)n.pos));
    }

    @Override
    protected boolean isPassable(BlockPos pos, boolean head, Node currentnode) {
        return true;
    }

    @Override
    protected boolean onLadderGoingDown(@NotNull Node currentNode, @NotNull BlockPos dPos) {
        return !currentNode.isSwimming();
    }

    @Override
    protected boolean onLadderGoingUp(@NotNull Node currentNode, @NotNull BlockPos dPos) {
        if (this.isWalkableSurface(this.world.func_180495_p(currentNode.pos), currentNode.pos) == AbstractPathJob.SurfaceType.WALKABLE) {
            return true;
        }
        if (dPos.func_177956_o() >= 0 || dPos.func_177958_n() != 0 || dPos.func_177952_p() != 0) {
            if (currentNode.isLadder()) {
                return true;
            }
            for (Direction dir : PathingStuckHandler.HORIZONTAL_DIRS) {
                BlockState toPlace = (BlockState)Blocks.field_150468_ap.func_176223_P().func_206870_a((Property)LadderBlock.field_176382_a, (Comparable)dir.func_176734_d());
                if (!this.world.func_180495_p(currentNode.pos.func_177972_a(dir)).func_185904_a().func_76220_a() || !Blocks.field_150468_ap.func_196260_a(toPlace, this.world, currentNode.pos)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected int getGroundHeight(Node parent, @NotNull BlockPos pos) {
        int height = super.getGroundHeight(parent, pos);
        if (height != pos.func_177956_o()) {
            this.addCost = 0.5;
        }
        if (parent.pos.func_177958_n() - pos.func_177958_n() == 0 && parent.pos.func_177952_p() - pos.func_177952_p() == 0 || Math.abs(height - pos.func_177956_o()) > 1 && this.isWalkableSurface(this.world.func_180495_p(pos.func_177977_b()), pos.func_177977_b()) == AbstractPathJob.SurfaceType.WALKABLE) {
            this.addCost = 3.5;
            return pos.func_177956_o();
        }
        return height;
    }

    @Override
    protected double computeCost(@NotNull BlockPos dPos, boolean isSwimming, boolean onPath, boolean onRails, boolean railsExit, boolean swimStart, boolean corner, BlockPos blockPos) {
        double modifier = this.addCost;
        this.addCost = 1.0;
        if (!super.isPassable(blockPos, false, null)) {
            modifier *= 30.0;
        }
        if (!corner && this.isWalkableSurface(this.world.func_180495_p(blockPos.func_177977_b()), blockPos.func_177977_b()) != AbstractPathJob.SurfaceType.WALKABLE) {
            modifier *= 30.0;
        }
        return super.computeCost(dPos, isSwimming, onPath, onRails, railsExit, swimStart, corner, blockPos) * modifier;
    }
}

